/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx.offline;

import com.sothawo.mapjfx.offline.CachedDataInfo;
import com.sothawo.mapjfx.offline.OfflineCache;
import com.sothawo.mapjfx.offline.WriteCacheFileInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.Path;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingHttpsURLConnection
extends HttpsURLConnection {
    private static final Logger logger = LoggerFactory.getLogger(CachingHttpsURLConnection.class);
    private final HttpsURLConnection delegate;
    private final Path cacheFile;
    private final OfflineCache cache;
    private boolean readFromCache = false;
    private InputStream inputStream;
    private CachedDataInfo cachedDataInfo;

    private CachingHttpsURLConnection(URL url) {
        super(url);
        this.cache = null;
        this.delegate = null;
        this.cacheFile = null;
    }

    public CachingHttpsURLConnection(OfflineCache cache, HttpsURLConnection delegate) throws IOException {
        super(delegate.getURL());
        this.cache = cache;
        this.delegate = delegate;
        this.cacheFile = cache.filenameForURL(delegate.getURL());
        this.cachedDataInfo = cache.readCachedDataInfo(this.cacheFile);
        boolean bl = this.readFromCache = cache.isCached(delegate.getURL()) && null != this.cachedDataInfo;
        if (!this.readFromCache) {
            this.cachedDataInfo = new CachedDataInfo();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("in cache: {}, URL: {}, cache file: {}", new Object[]{this.readFromCache, delegate.getURL().toExternalForm(), this.cacheFile});
        }
    }

    @Override
    public void connect() throws IOException {
        if (!this.readFromCache) {
            if (logger.isTraceEnabled()) {
                logger.trace("connect to {}", (Object)this.delegate.getURL().toExternalForm());
            }
            this.delegate.connect();
        }
    }

    @Override
    public String getCipherSuite() {
        return this.delegate.getCipherSuite();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.delegate.getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return this.delegate.getServerCertificates();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.delegate.getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.delegate.getLocalPrincipal();
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.delegate.getHeaderFieldKey(n);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.delegate.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        this.delegate.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.delegate.addRequestProperty(key, value);
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
        this.delegate.setChunkedStreamingMode(chunklen);
    }

    @Override
    public String getHeaderField(int n) {
        return this.delegate.getHeaderField(n);
    }

    @Override
    public void disconnect() {
        if (!this.readFromCache) {
            this.delegate.disconnect();
        }
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.delegate.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this.readFromCache ? 10 : this.delegate.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.delegate.getContent(classes);
    }

    @Override
    public String getContentEncoding() {
        if (!this.readFromCache) {
            this.cachedDataInfo.setContentEncoding(this.delegate.getContentEncoding());
        }
        return this.cachedDataInfo.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.readFromCache ? -1 : this.delegate.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        return this.readFromCache ? -1L : this.delegate.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        if (!this.readFromCache) {
            this.cachedDataInfo.setContentType(this.delegate.getContentType());
        }
        return this.cachedDataInfo.getContentType();
    }

    @Override
    public long getDate() {
        return this.readFromCache ? 0L : this.delegate.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.delegate.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.delegate.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.delegate.getDoOutput();
    }

    @Override
    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    @Override
    public long getExpiration() {
        return this.readFromCache ? 0L : this.delegate.getExpiration();
    }

    @Override
    public String getHeaderField(String name) {
        return this.delegate.getHeaderField(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        return this.delegate.getHeaderFieldDate(name, Default);
    }

    @Override
    public int getHeaderFieldInt(String name, int Default) {
        return this.delegate.getHeaderFieldInt(name, Default);
    }

    @Override
    public long getHeaderFieldLong(String name, long Default) {
        return this.delegate.getHeaderFieldLong(name, Default);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (!this.readFromCache) {
            this.setHeaderFieldsInCachedDataInfo();
        }
        return this.cachedDataInfo.getHeaderFields();
    }

    private void setHeaderFieldsInCachedDataInfo() {
        this.cachedDataInfo.setHeaderFields(this.delegate.getHeaderFields());
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.delegate.getHostnameVerifier();
    }

    @Override
    public long getIfModifiedSince() {
        return this.delegate.getIfModifiedSince();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (null == this.inputStream) {
            if (this.readFromCache) {
                this.inputStream = new FileInputStream(this.cacheFile.toFile());
            } else {
                WriteCacheFileInputStream wis = new WriteCacheFileInputStream(this.delegate.getInputStream(), new FileOutputStream(this.cacheFile.toFile()));
                wis.onInputStreamClose(() -> {
                    block5: {
                        try {
                            this.cachedDataInfo.setFromHttpUrlConnection(this.delegate);
                            int responseCode = this.delegate.getResponseCode();
                            if (responseCode == 200) {
                                this.cache.saveCachedDataInfo(this.cacheFile, this.cachedDataInfo);
                            } else if (logger.isWarnEnabled()) {
                                logger.warn("not caching because of response code {}: {}", (Object)responseCode, (Object)this.getURL());
                            }
                        }
                        catch (IOException e) {
                            if (!logger.isWarnEnabled()) break block5;
                            logger.warn("cannot retrieve response code");
                        }
                    }
                });
                this.inputStream = wis;
            }
        }
        return this.inputStream;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.delegate.getInstanceFollowRedirects();
    }

    @Override
    public long getLastModified() {
        return this.readFromCache ? 0L : this.delegate.getLastModified();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.delegate.getPermission();
    }

    @Override
    public int getReadTimeout() {
        return this.delegate.getReadTimeout();
    }

    @Override
    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.delegate.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return this.delegate.getRequestProperty(key);
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.readFromCache ? 200 : this.delegate.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.readFromCache ? "OK" : this.delegate.getResponseMessage();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.delegate.getSSLSocketFactory();
    }

    @Override
    public URL getURL() {
        return this.delegate.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.delegate.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.delegate.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.delegate.setConnectTimeout(timeout);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.delegate.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public void setDoInput(boolean doinput) {
        this.delegate.setDoInput(doinput);
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.delegate.setDoOutput(dooutput);
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.delegate.setHostnameVerifier(hostnameVerifier);
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.delegate.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.delegate.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.delegate.setReadTimeout(timeout);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.delegate.setRequestMethod(method);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.delegate.setRequestProperty(key, value);
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.delegate.setSSLSocketFactory(sslSocketFactory);
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.delegate.setUseCaches(usecaches);
    }

    @Override
    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }
}

